/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.Player;
import dangerzone.TextureMapper;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import org.newdawn.slick.opengl.Texture;

public class Chipmunk
extends EntityLiving {
    public Chipmunk(World w) {
        super(w);
        this.maxrenderdist = 100;
        this.height = 0.5f;
        this.width = 0.5f;
        this.uniquename = "OreSpawn:Chipmunk";
        this.moveSpeed = 0.25f;
        this.setMaxHealth(5.0f);
        this.setHealth(5.0f);
        this.setDefense(1.0f);
        this.setAttackDamage(0.0f);
        this.movefrequency = 25;
        this.setExperience(1);
        this.enable_avoid = true;
        this.avoiddistance = 16;
        this.enable_findfoodblock = true;
        this.foodblockfreq = 60;
        this.foodblockdistxz = 13;
        this.foodblockdisty = 4;
        this.foodblockdisteat = 12;
        this.foodblockheal = 1;
        this.canSwim = true;
        this.enable_taming = true;
        this.maxdisttoowner = 18.0f;
        this.enable_followfood = true;
        this.foodsearchDistance = 12;
        this.enable_droppedfood = true;
        this.enableBreeding(10);
        this.findbuddydistance = 16;
        this.findbuddyfrequency = 8;
    }

    public boolean isBuddy(Entity e) {
        return e instanceof Chipmunk;
    }

    public boolean isBreedingFoodForMe(int bid, int iid) {
        if (iid == OreSpawnMain.crystalapple.itemID) {
            return true;
        }
        return this.isFoodForMe(bid, iid);
    }

    public boolean shouldAvoidEntity(Entity e) {
        if (e.temperament == 1) {
            return true;
        }
        return this.getOwnerName() == null && e instanceof Player;
    }

    public void doEntityAction(float deltaT) {
        int bid;
        this.enable_buddy = this.isBaby();
        super.doEntityAction(deltaT);
        if (this.world.rand.nextInt(1000) == 1 && (bid = this.world.getblock(this.dimension, (int)this.posx, (int)this.posy - 1, (int)this.posz)) == Blocks.grassblock.blockID) {
            if (this.world.rand.nextBoolean()) {
                this.world.setblockandmetaWithPerm((Entity)this, this.dimension, (int)this.posx, (int)this.posy - 1, (int)this.posz, 0, 0);
            } else {
                this.world.setblockandmetaWithPerm((Entity)this, this.dimension, (int)this.posx, (int)this.posy - 1, (int)this.posz, Blocks.dirt.blockID, 0);
            }
        }
    }

    public boolean isFoodBlock(int bid) {
        if (bid == Blocks.flower_red.blockID || bid == Blocks.flower_pink.blockID || bid == Blocks.flower_purple.blockID) {
            return true;
        }
        return bid == Blocks.flower_yellow.blockID;
    }

    public boolean isFoodItem(int iid) {
        return iid == Items.apple.itemID;
    }

    public void doEatFoodAction(int d, int x, int y, int z) {
        if (this.world.getblock(d, x, y - 1, z) == Blocks.grassblock.blockID) {
            this.world.setblockandmetaWithPerm((Entity)this, d, x, y - 1, z, 0, 0);
        }
        super.doEatFoodAction(d, x, y, z);
    }

    public String getLivingSound() {
        return null;
    }

    public String getHurtSound() {
        return "OreSpawn:scorpion_hit";
    }

    public String getDeathSound() {
        return "OreSpawn:cryo_death";
    }

    public void doDeathDrops() {
        Utils.doDropRand((World)this.world, (int)Blocks.flower_yellow.blockID, (int)0, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophychipmunk.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        super.doDeathDrops();
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/chipmunktexture.png");
        }
        return this.texture;
    }
}

